package com.junkprojects.comm.rpc;

public class RPCRejectedReplyMessage extends RPCReplyMessage {

  protected static int RJT_RPC_MISMATCH  = 0;
  protected static int RJT_AUTH_ERROR    = 1;

  public static int AUTH_OK           = 0;
  public static int AUTH_BADCRED      = 1;
  public static int AUTH_REJECTEDCRED = 2;
  public static int AUTH_BADVERF      = 3;
  public static int AUTH_REJECTEDVERF = 4;
  public static int AUTH_TOOWEAK      = 5;
  public static int AUTH_INVALIDRESP  = 6;
  public static int AUTH_FAILED       = 7;


  int _lowvernumb,
      _highvernumb   = 0;

  int _rejecttype = -1;

  int _authfailcode = -1;


  public RPCRejectedReplyMessage(int xid,
                                 int lowvernumb,
                                 int highvernumb) 
  {

    super();

    _rejecttype = RJT_RPC_MISMATCH;
    _replymessagetype = RPLY_DENIED;

    _xid = xid;
    _lowvernumb = lowvernumb;
    _highvernumb = highvernumb;

  }

  public RPCRejectedReplyMessage(int xid,
                                 int authfailcode) 
         throws RPCMessageException
  {

    super();

    if ((authfailcode < 0) || (authfailcode >8))
      throw new RPCMessageException("Invalid authentication failure "+
                                    "code, value "+authfailcode+".");

    _rejecttype = RJT_AUTH_ERROR;
    _replymessagetype = RPLY_DENIED;

    _xid = xid;
    _authfailcode =  authfailcode;


  } 

  public int getLength() {

    int len = 0;

    len = 12;

    if (_rejecttype == RJT_RPC_MISMATCH) {
      len = len + 8;
    } else
      len = len + 4;

    return len;

  }

  public int getAuthenticationFailCode() {
    return _authfailcode;
  }

  public int getHighRPCVersion() {
    return _highvernumb;
  }

  public int getLowRPCVersion() {
    return _lowvernumb;
  }

  public int getRejectedReplyMessageType() {

    return _rejecttype;

  }

  public String toString() {

    if (_rejecttype == RJT_RPC_MISMATCH) 
      return new String ("Transaction Id -> "+_xid+"\n"+
                         "Low RPC version -> "+_lowvernumb+"\n"+
                         "High RPC Version -> "+_highvernumb);

    else if (_rejecttype == RJT_AUTH_ERROR)
      return new String ("Transaction Id -> "+_xid+"\n"+
                         "Authentication fail code "+_authfailcode);
    else  
      return new String ("Unknown reject type "+_rejecttype);

  }


} 
