package com.junkprojects.comm.rpc;

import java.util.*;
import java.io.*;

public class RPCCallMessage extends RPCMessage {

  int _len                    = -1;
  int _rpcversion             = 2;
  int _program                = -1;
  int _version                = -1;
  int _procedure              = -1;
  byte[] _procparams          = null;
  RPCAuthentication _creds    = null;

  public RPCCallMessage() {

    super();
    _messagetype = RPCMessage.MSGTYPE_CALL;

  }                    
  
  public RPCCallMessage(int xid,
                        int program,
                        int version,
                        int procedure,
                        RPCAuthentication creds,
                        RPCAuthentication verifier,
                        byte[] procparams)
  {

    super();

    RPCXidGen xidgen = null;

    _messagetype = RPCMessage.MSGTYPE_CALL;
 
    _xid = xid;
    _program = program;
    _version = version;
    _procedure = procedure;
    _creds = creds;
    _verifier = verifier;
    _procparams = procparams; 

    if (_xid <= 0) {
      xidgen = RPCXidGen.getInstance();
      _xid = xidgen.newXid();
    }

  }

  public RPCCallMessage(int xid,
                        int program,
                        int version,
                        int procedure,
                        byte[] procparams)
  {

    new RPCCallMessage(xid,program,version,procedure,null,null,procparams);

  }

  public int getLength() {

    byte sink[] = null;

    _len = 26;

    if (_creds != null) {
      sink = _creds.getRawParams();
      if (sink != null)
        _len = _len + sink.length;
    }
 
    if (_verifier != null) { 
      sink = _verifier.getRawParams();
      if (sink != null)
        _len = _len + sink.length;
    }

    sink = null;

    if (_procparams != null)
      _len = _len + _procparams.length;

    return _len;

  }           


  public int getProgramNumber() {
    return _program;
  }

  public int getProgramVersion() {
    return _version;
  }

  public int getProcedureNumber() {
    return _procedure;
  }

  public RPCAuthentication getCredentails() {
    return _creds;
  }

  public RPCAuthentication getVerifier() {
    return _verifier;
  }

  public byte[] getParamaters() {
    return _procparams;
  }

  public void setProgramNumber(int program) {
    _program = program;
  }

  public void setProgramVersion(int version) {
    _version = version;
  }

  public void setProcedureNumber(int procedure) {
    _procedure = procedure;
  }

  public void setCredentails(RPCAuthentication creds) {
    _creds = creds;
  }

  public void setVerifier(RPCAuthentication verifier) {
    _verifier = verifier;
  }

  public void setParamaters(byte[] procparams) {
    _procparams = procparams;
  }

  public String toString() {

     return new String("Transaction id -> "+_xid+"\n"+
                       "Program number -> "+_program+"\n"+
                       "Program version -> "+_version+"\n"+
                       "Procedure number -> "+_procedure+"\n"+
                       "Params -> "+new String(_procparams)+"\n");

  }


}
